<?php
$key1 = ''; // Client authentication key #1
$key2 = ''; // Client authentication key #2
$bot_url = 'https://localhost:8443';

/**
 *
 * @return string
 */
function getTokenKey() {
    // If we are planning to integrate other chat bots from the same server
    // we need to use unique token key for each connection
    return 'TOKEN_'.$_SERVER['SERVER_NAME'].':'.$_SERVER['SERVER_PORT'];
}

/**
 * Procede to authenticate login to chat bot server.
 * @return boolean True when successfully authenticated.
 */
function login() {
	global $key1, $key2, $bot_url;
	$token = apcu_fetch(getTokenKey());
	if(!empty($token)) {
		error_log(getTokenKey().' already logged in!');
		return true;
	}
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $bot_url."/login");
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array('key1' => $key1, 'key2' => $key2)));
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Remove on production
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0); // Remove on production
	curl_setopt($ch, CURLOPT_HTTPHEADER, [
	    'Content-Type: application/x-www-form-urlencoded',
	]);
	//curl_setopt($ch, CURLOPT_VERBOSE, true);
	$response = curl_exec($ch);
	curl_close($ch);
	if(session_id() == '') {
	    session_destroy();
		session_start();
	}
	$response = json_decode($response, true);
	if($response['STATUS'] == 'OK') {
		apcu_store(getTokenKey(), $response['TOKEN']);
		return true;
	} else {
		return false;
	}
}

/**
 * Log out the chat bot server.
 * @return boolean True when successfully logged out.
 */
function logout() {
	global $bot_url;
	$token = apcu_fetch(getTokenKey());
	if(!empty($token)) {
    	$ch = curl_init();
    	curl_setopt($ch, CURLOPT_URL, $bot_url."/logout");
    	curl_setopt($ch, CURLOPT_POST, 1);
    	curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array('token' => $token)));
    	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Remove on production
    	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0); // Remove on production
    	$response = curl_exec($ch);
    	curl_close($ch);
    	// TODO : Log if logout fails
		apcu_delete(getTokenKey());
    	session_destroy();
    	session_start();
    	return true;
	}
	return false;
}

/**
 * Starts a chat session with the chat bot server.
 * @param string $usr_id ID of the user. Chat sessions are taken over when called again.
 * @return json|boolean json response on success, false on error.
 */
function lets_chat($usr_id) {
	global $bot_url;
	$token = apcu_fetch(getTokenKey());
	if(!empty($token)) {
	    $ch = curl_init();
    	curl_setopt($ch, CURLOPT_URL, $bot_url."/letschat");
    	curl_setopt($ch, CURLOPT_POST, 1);
    	curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array('usr_id' => $usr_id, 'token' => $token)));
    	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    	$response = curl_exec($ch);
    	curl_close($ch);
    	$response = json_decode($response, true);
    	if($response['STATUS'] == 'OK')
    		return $response;
	}
	return false;
}

/**
 * Sends a user message to the chat bot server and wait for a response.
 * @param string $usr_id User ID.
 * @param string $message User message.
 * @return json|boolean json response on success, false on error.
 */
function send_message($usr_id, $message) {
	global $bot_url;
	$token = apcu_fetch(getTokenKey());
	if(!empty($token)) {
	    $ch = curl_init();
    	curl_setopt($ch, CURLOPT_URL, $bot_url."/message");
    	curl_setopt($ch, CURLOPT_POST, 1);
    	curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array('usr_id' => $usr_id, 'token' => $token, 'message' => $message)));
    	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    	$response = curl_exec($ch);
    	curl_close($ch);
    	$response = json_decode($response, true);
    	if($response['STATUS'] == 'OK')
    		return $response;
    }
	return false;
}

/*****************************************************************************/
/*                                                                           */
/*****************************************************************************/
$qid = null;
$token = null;
$response = '';
session_start();
if(!empty($_GET['qid'])) {
    $qid = $_GET['qid'];
    switch($qid) {
        case 'info':
            phpinfo();
            exit;
            break;
        case 'login':
            $response = login();
            if($response === true) {
                //header('200 OK', true, 200);
                header('Content-Type: application/json');
                echo json_encode(array('STATUS' => 'OK', 'CODE' => 200, 'MESSAGE' => 'OK'));
                exit;
            } else {
                header('401 Unauthorized', true, 401);
                header('Content-Type: application/json');
                echo json_encode(array('STATUS' => 'ERROR', 'CODE' => 401, 'MESSAGE' => 'Unauthorized'));
                exit;
            }
			break;
		case 'logout':
			$response = logout();
			if($response === true) {
			    //header('200 OK', true, 200);
			    header('Content-Type: application/json');
			    echo json_encode(array('STATUS' => 'OK', 'CODE' => 200, 'MESSAGE' => 'OK'));
			    exit;
			} else {
			    header('401 Unauthorized', true, 401);
			    header('Content-Type: application/json');
			    echo json_encode(array('STATUS' => 'ERROR', 'CODE' => 401, 'MESSAGE' => 'Unauthorized'));
			    exit;
			}
			break;
		case 'letschat':
		    $usr_id = null;
		    if(!empty($_POST['usr_id']))
		        $usr_id = $_POST['usr_id'];
	        if(!empty($usr_id)) {
    			$response = lets_chat($usr_id);
    			if($response !== false) {
    			    header('Content-Type: application/json');
    				echo json_encode($response);
    				exit;
    			} else {
    			    header('401 Unauthorized', true, 401);
    			    header('Content-Type: application/json');
    			    echo json_encode(array('STATUS' => 'ERROR', 'CODE' => 401, 'MESSAGE' => 'Unauthorized'));
    			    exit;
    			}
	        }
			break;
		case 'message':
		    $usr_id = null;
		    $message = null;
		    if(!empty($_POST['usr_id']))
		        $usr_id = $_POST['usr_id'];
		    if(isset($_POST['message']))
		        $message = trim($_POST['message']);
	        if(!empty($usr_id) && (strlen($message) > 0)) {
	            $response = send_message($usr_id, $message);
    			if($response !== false) {
    			    header('Content-Type: application/json');
    				echo json_encode($response);
    				exit;
    			} else {
    			    header('401 Unauthorized', true, 401);
    			    header('Content-Type: application/json');
    			    echo json_encode(array('STATUS' => 'ERROR', 'CODE' => 401, 'MESSAGE' => 'Unauthorized'));
    			    exit;
    			}
	        }
			break;
    }
}
header('Content-Type: application/json');
$token = apcu_fetch(getTokenKey());
if(empty($token)) {
    header('401 Unauthorized', true, 401);
    echo json_encode(array('STATUS' => 'ERROR', 'CODE' => 401, 'MESSAGE' => 'Unauthorized'));
} else {
    header('400 Bad Request', true, 400);
    echo json_encode(array('STATUS' => 'ERROR', 'CODE' => 400, 'MESSAGE' => 'Bad Request'));
}
?>










