var aimodel = '<div class="ai_msg"><img class="ai_msg_avatar" src="img/_.*._" /><div class="ai_msg_content">_.#._</div></div>';
var usrmodel = '<div class="usr_msg"><img class="usr_msg_avatar" src="img/person.png" /><div class="usr_msg_content"><p class="usr_msg_content">_.#._</p></div></div>';

function safeHTML(text) {
    const div = document.createElement('div');
    div.textContent = text;
    return div.innerHTML;
}
function idSel(id) { return document.getElementById(id); }
function clsSel(cls) { return document.getElementsByClassName(cls); }
function getClientId() {
    let clientId = localStorage.getItem('clientId');
    if (!clientId) {
        clientId = Math.random().toString(36).substr(2, 9); //crypto.randomUUID();
        localStorage.setItem('clientId', clientId);
    }
    return clientId;
}
function scrollToBottom(container) {
	setTimeout(() => {
		container.scrollTo( { top: container.lastElementChild.offsetTop-container.offsetTop, behavior: 'smooth' } );
	}, 100);
}
function linkify(text) {
    const urlPattern = /(https?:\/\/[^\s]+)/g;
    return text.replace(urlPattern, '<a href="$1" target="_blank" title="$1" style="font-weight:bold;white-space: nowrap;">👉🔗↗</a>');
}
function disableSendButtons() {
	const els = document.querySelectorAll('[id^="btnsnd_"]');
	els.forEach(el => {
		el.setAttribute('id', '');
		el.setAttribute('class', 'btn_snd_disabled');
		el.addEventListener("click", function (event) { utamsg.focus(); });
	});
}
function clickToSendAuto(event) {
	const asnd = event.target;
	const id = asnd.id;
	if(id && id.startsWith("btnsnd_")) {
		const suffix = id.substring("btnsnd_".length);
		let utamsg = idSel('utamsg');
		let btnSend = idSel('btnmsg');
		utamsg.value = suffix.replace('_', ' ');
		btnSend.click();
	}
}

const clientId = getClientId();
/**
 *
 */
function onBotLoginSuccess(response) {
	let newChat = idSel('newchat');
	let msgs = idSel("msglist");
	let ldn = idSel('loading');
	if(response.STATUS === 'OK') {
		newChat.style.display = 'none';
		ldn.style.display = 'block';
		fetch('bot/?qid=letschat', {
			method : 'POST',
			headers: {
			    'Content-Type': 'application/x-www-form-urlencoded'
			},
			body: new URLSearchParams({
				usr_id : clientId
			}).toString()
		})
		  .then(response => {
			ldn.style.display = 'none';
		    if (!response.ok)
		      throw new Error('Erreur de lancement de la discussion : ' + response.statusText);
		    return response.json();
		  })
		  .then(data => {
		    console.log('Data received:', data);
			msgs.innerHTML = '';
			let img = data.CHAT_STATE=='AIMODEL' ? 'assistant.png' : (data.CHAT_STATE=='AGENT' ? 'agent.png' : 'chatbot.png');
			for(let msg of data.CHATBOT_MESSAGE)
				msgs.insertAdjacentHTML('beforeend', aimodel.replace('_.#._', msg.replaceAll('\\n', '<br/>')).replace('_.*._', img));
			scrollToBottom(msgs);
			idSel('utamsg').removeAttribute('disabled');
			idSel('btnmsg').removeAttribute('disabled');
			utamsg.value ='';
			utamsg.focus();
		  })
		  .catch(error => {
		    console.error('Erreur : ', error);
			msgs.insertAdjacentHTML('beforeend', aimodel.replace('_.#._', '<span style="color:red">Erreur! Ré-essayez plus tard...</span>'));
			scrollToBottom(msgs);
			onBotInitFailure();
		  });
	}
}

/**
 *
 */
function onBotInitFailure() {
	fetch('bot/?qid=logout')
		.then(response => {
			const iframe = window.parent.document.getElementById('chat4usIframe');
			iframe.src = iframe.src.split('?')[0] + '?t=' + new Date().getTime();
		});
}

window.onload = function() {
	let msgs = idSel("msglist");
	msgs.innerHTML = "";
	let tbm = idSel("tobtm");
	tbm.style.visibility = "hidden";
	let newChat = idSel('newchat');
	let ldn = idSel('loading');
	newChat.addEventListener('click', () => {
		newChat.style.display = 'none';
		ldn.style.display = 'block';
		fetch('bot/?qid=login')
		  .then(response => {
			ldn.style.display = 'none';
		    if (!response.ok)
		      throw new Error('Erreur de connection : ' + response.statusText);
		    return response.json();
		  })
		  .then(data => {
		    console.log('Data received:', data);
			onBotLoginSuccess(data);
		  })
		  .catch(error => {
		    console.error('Erreur : ', error);
			msgs.insertAdjacentHTML('beforeend', aimodel.replace('_.#._', '<span style="color:red">Erreur! Ré-essayez plus tard...</span>'));
			scrollToBottom(msgs);
			//newChat.style.display = 'table';
			onBotInitFailure();
		  });
	});

	let utamsg = idSel('utamsg');
	let btnSend = idSel('btnmsg');
	btnSend.addEventListener('click', () => {
		if(utamsg.value.trim().length > 0) {
			if(utamsg.value != '...') {
				msgs.insertAdjacentHTML('beforeend', usrmodel.replace('_.#._', safeHTML(utamsg.value)));
				scrollToBottom(msgs);
			}
			idSel('utamsg').setAttribute('disabled', '');
			idSel('btnmsg').setAttribute('disabled', '');
			ldn.style.display = 'block';
			let msg = utamsg.value.trim();
			utamsg.value = "";
			fetch('bot/?qid=message', {
				method : 'POST',
				headers: {
				    'Content-Type': 'application/x-www-form-urlencoded'
				},
				body: new URLSearchParams({
					usr_id : clientId,
					message : msg
				}).toString()
			})
			.then(response => {
				ldn.style.display = 'none';
			    if (!response.ok)
			    	throw new Error('Erreur de l\'envoi du message : ' + response.statusText);
				return response.json();
			})
			.then(data => {
			    console.log('Data received:', data);
				disableSendButtons();
				let img = data.CHAT_STATE=='AIMODEL' ? 'assistant.png' : (data.CHAT_STATE=='AGENT' ? 'agent.png' : 'chatbot.png');
				for(let msg of data.CHATBOT_MESSAGE) {
					if(msg.trim().length > 0) {
						if(data.CHAT_STATE=='AIMODEL')
							msg = linkify(msg);
						msgs.insertAdjacentHTML('beforeend', aimodel.replace('_.#._', msg.replaceAll('\\n', '<br/>')).replace('_.*._', img));
					}
				}
				scrollToBottom(msgs);
				if(!data.CHAT_ENDED) {
					btnSend.removeAttribute('disabled');
					utamsg.removeAttribute('disabled');
					utamsg.value = '';
					utamsg.focus();
				} else {
					btnSend.setAttribute('disabled', '');
					utamsg.setAttribute('disabled', '');
					utamsg.value = 'La discussion est terminée.';
					newChat.style.display = 'table';
				}
				if(data.CHATBOT_WAITING == true) {
					utamsg.value = "...";
					btnSend.click();
				}
			})
			.catch(error => {
			    console.error('Erreur : ', error);
				msgs.insertAdjacentHTML('beforeend', aimodel.replace('_.#._', '<span style="color:red">Erreur! Ré-essayez plus tard...</span>'));
				scrollToBottom(msgs);
				btnSend.setAttribute('disabled', '');
				utamsg.setAttribute('disabled', '');
				utamsg.value = 'La discussion est terminée.';
				newChat.style.display = 'table';
			});
		}
	});

	utamsg.addEventListener('keyup', (e) => {
		if(e.keyCode == 13)
			btnSend.click();
	});

	msgs.addEventListener('scroll', () => {
		let s = msgs.scrollTop + msgs.offsetTop + msgs.clientHeight < msgs.lastElementChild.offsetTop;//+msgs.lastElementChild.clientHeight;
		tbm.style.visibility = s ? 'visible' : 'hidden';
	});

	tbm.addEventListener('click', () => {
		scrollToBottom(msgs);
	});

	document.body.onresize = function() {
		let um = clsSel('user_message')[0];
		msgs.style.height = (um.offsetTop - msgs.offsetTop - 5) + 'px';
	}

	document.addEventListener("click", function(event) {
	  if(event.target.closest('[id^="btnsnd_"]'))
	    clickToSendAuto(event);
	});

	document.body.onresize();
};








