/*
 * Decompiled with CFR 0.152.
 */
package chatclient;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Image;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.text.html.HTMLEditorKit;

public class Helper {
    private static final String ALNUM_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static String getRandomString(int length) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < length) {
            sb.append(ALNUM_CHARS.charAt((int)(Math.random() * (double)ALNUM_CHARS.length())));
            ++i;
        }
        return sb.toString();
    }

    public static void setupEditorPane(JEditorPane editorPane) {
        editorPane.setContentType("text/html");
        editorPane.setEditorKit(new HTMLEditorKit());
    }

    public static String getLocalTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        return sdf.format(new Date());
    }

    public static String getLocalTime(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        return sdf.format(new Date(time));
    }

    public static Icon loadIconFromResources(String resourcePath, int width, int height) {
        try {
            URL resourceURL = Helper.class.getResource(resourcePath);
            if (resourceURL == null) {
                throw new IllegalArgumentException("Resource not found: " + resourcePath);
            }
            ImageIcon imageIcon = new ImageIcon(resourceURL);
            Image originalImage = imageIcon.getImage();
            Image resizedImage = originalImage.getScaledInstance(width, height, 4);
            return new ImageIcon(resizedImage);
        }
        catch (Exception e) {
            System.err.println("Error loading icon: " + resourcePath);
            return null;
        }
    }

    public static boolean isRTL(Locale locale) {
        char firstChar = locale.getDisplayName(locale).charAt(0);
        byte directionality = Character.getDirectionality(firstChar);
        return directionality == 1 || directionality == 2;
    }

    public static void enableRtlWhenNeeded(Container container) {
        if (!Helper.isRTL(Locale.getDefault())) {
            return;
        }
        container.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof Container) {
                Helper.enableRtlWhenNeeded((Container)component);
            }
            ++n2;
        }
        container.revalidate();
        container.repaint();
    }

    public static String escapeHtml(String text) {
        if (text == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(text.length() * 2);
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '&') {
                sb.append("&amp;");
            } else if (c == '<') {
                sb.append("&lt;");
            } else if (c == '>') {
                sb.append("&gt;");
            } else if (c == '\"') {
                sb.append("&quot;");
            } else if (c == '\'') {
                sb.append("&#39;");
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }
}

