/*
 * Decompiled with CFR 0.152.
 */
package chatclient;

import chatclient.ConnectDialog;
import chatclient.ErrorMessage;
import chatclient.Helper;
import chatclient.RemoteMessage;
import chatclient.ServerConnector;
import chatclient.UserMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static MainFrame INSTANCE;
    private ServerConnector connector = null;
    private String userId = null;
    private JPanel contentPane;
    private JTextField tfUserMsg;
    private JPanel pnlChat;
    private JButton btnSend;
    private JToggleButton tglConnect;
    private JScrollPane spChat;
    private JProgressBar pbWait;

    public static void onRemoteMsgLinkClicked(String id) {
        if (id != null && !id.isBlank() && id.startsWith("btn_snd_")) {
            String response = id.substring(8).replaceAll("_", " ");
            MainFrame.INSTANCE.tfUserMsg.setText(response);
            MainFrame.INSTANCE.btnSend.doClick();
        }
    }

    private void scrollToBottom() {
        final Timer timer = new Timer(10, null);
        ActionListener al = new ActionListener(){
            float steps = -1.0f;

            @Override
            public void actionPerformed(ActionEvent e) {
                JScrollBar bar = MainFrame.this.spChat.getVerticalScrollBar();
                int max = bar.getMaximum() - bar.getVisibleAmount();
                if (this.steps < 0.0f) {
                    this.steps = (max - bar.getValue()) / 10;
                }
                bar.setValue(bar.getValue() + Math.round(this.steps *= 0.915f));
                if (this.steps <= 1.0f) {
                    this.steps = 1.0f;
                }
                if (bar.getValue() >= max) {
                    timer.stop();
                }
            }
        };
        timer.addActionListener(al);
        timer.start();
    }

    public MainFrame() {
        INSTANCE = this;
        this.setDefaultCloseOperation(3);
        this.setTitle("Chat4Us - Client example");
        this.setBounds(100, 100, 420, 600);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JToolBar toolBar = new JToolBar();
        toolBar.setBorder(new EtchedBorder(1, null, null));
        this.contentPane.add((Component)toolBar, "North");
        this.tglConnect = new JToggleButton("Connect");
        this.tglConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainFrame.this.tglConnect.isSelected()) {
                    ConnectDialog dlg = new ConnectDialog();
                    dlg.setLocationRelativeTo(MainFrame.this);
                    dlg.setVisible(true);
                    if (!dlg.isCancelled()) {
                        MainFrame.this.pnlChat.removeAll();
                        MainFrame.this.connector = new ServerConnector(dlg.getKey1(), dlg.getKey2(), "https://" + dlg.getHost() + ":" + dlg.getPort());
                        if (MainFrame.this.connector.login()) {
                            MainFrame.this.userId = Helper.getRandomString(10);
                            ServerConnector.ApiResponse response = MainFrame.this.connector.letsChat(MainFrame.this.userId);
                            if (response != null && response.isSuccess()) {
                                String[] messages;
                                String[] stringArray = messages = response.getMessages();
                                int n = messages.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String message = stringArray[n2];
                                    RemoteMessage panel = new RemoteMessage();
                                    panel.setMessage(message, System.currentTimeMillis());
                                    MainFrame.this.pnlChat.add(panel);
                                    MainFrame.this.pnlChat.revalidate();
                                    MainFrame.this.pnlChat.repaint();
                                    ++n2;
                                }
                                if (!response.isChatEnded()) {
                                    MainFrame.this.btnSend.setEnabled(true);
                                    MainFrame.this.tfUserMsg.setEnabled(true);
                                    MainFrame.this.tfUserMsg.requestFocusInWindow();
                                }
                            }
                        } else {
                            JOptionPane.showMessageDialog(MainFrame.this, "Connection failed!\nPlease try again later...", "Connection failed!", 0);
                            MainFrame.this.tglConnect.setSelected(false);
                        }
                    }
                    dlg.dispose();
                } else {
                    MainFrame.this.pnlChat.setEnabled(true);
                    MainFrame.this.tfUserMsg.setEnabled(false);
                    MainFrame.this.btnSend.setEnabled(false);
                    MainFrame.this.pbWait.setVisible(false);
                    JOptionPane.showMessageDialog(MainFrame.this, "You've been disconnected!\nPlease try again later...", "Disconnected!", 0);
                }
            }
        });
        this.tglConnect.setFocusable(false);
        toolBar.add(this.tglConnect);
        toolBar.addSeparator();
        this.pbWait = new JProgressBar();
        this.pbWait.setVisible(false);
        this.pbWait.setIndeterminate(true);
        toolBar.add(this.pbWait);
        JPanel panel = new JPanel();
        panel.setBorder(new EtchedBorder(1, null, null));
        this.contentPane.add((Component)panel, "South");
        this.tfUserMsg = new JTextField();
        this.tfUserMsg.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MainFrame.this.btnSend.doClick();
                }
            }
        });
        this.tfUserMsg.setEnabled(false);
        this.tfUserMsg.setColumns(10);
        this.btnSend = new JButton("Send");
        this.btnSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainFrame.this.connector != null && MainFrame.this.connector.isLoggedIn()) {
                    String msg = MainFrame.this.tfUserMsg.getText();
                    if (!msg.isBlank()) {
                        MainFrame.this.tfUserMsg.setText("");
                        MainFrame.this.tfUserMsg.setEnabled(false);
                        MainFrame.this.btnSend.setEnabled(false);
                        UserMessage panel = new UserMessage();
                        panel.setMessage(Helper.escapeHtml(msg), System.currentTimeMillis());
                        MainFrame.this.pnlChat.add(panel);
                        MainFrame.this.pbWait.setVisible(true);
                        MainFrame.this.pnlChat.revalidate();
                        MainFrame.this.pnlChat.repaint();
                        MainFrame.this.pnlChat.setEnabled(false);
                        MainFrame.this.tfUserMsg.setEnabled(false);
                        MainFrame.this.btnSend.setEnabled(false);
                        MainFrame.this.pbWait.setVisible(true);
                        Thread th = new Thread(() -> {
                            ServerConnector.ApiResponse response = MainFrame.this.connector.sendMessage(MainFrame.this.userId, msg);
                            if (response != null) {
                                this.handleServerAnswer(response);
                                if (response.isChatbotWaiting()) {
                                    SwingUtilities.invokeLater(() -> {
                                        MainFrame.this.pnlChat.setEnabled(false);
                                        MainFrame.this.tfUserMsg.setEnabled(false);
                                        MainFrame.this.btnSend.setEnabled(false);
                                        MainFrame.this.pbWait.setVisible(true);
                                    });
                                    ServerConnector.ApiResponse aiResponse = MainFrame.this.connector.sendMessage(MainFrame.this.userId, "...");
                                    this.handleServerAnswer(aiResponse);
                                }
                            } else {
                                SwingUtilities.invokeLater(() -> MainFrame.this.tglConnect.setSelected(false));
                            }
                        });
                        th.start();
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else {
                    MainFrame.this.tfUserMsg.setText("");
                    MainFrame.this.tfUserMsg.setEnabled(false);
                    MainFrame.this.btnSend.setEnabled(false);
                }
            }

            private void handleServerAnswer(ServerConnector.ApiResponse response) {
                if (response != null && response.isSuccess()) {
                    String[] messages;
                    String[] stringArray = messages = response.getMessages();
                    int n = messages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String message = stringArray[n2];
                        if (!message.isBlank()) {
                            SwingUtilities.invokeLater(() -> {
                                RemoteMessage pnl = new RemoteMessage();
                                pnl.setMessage(message, System.currentTimeMillis());
                                pnl.setIcon("/" + response.getChatStateIconName() + ".png");
                                MainFrame.this.pnlChat.add(pnl);
                            });
                        }
                        ++n2;
                    }
                    if (!response.isChatEnded()) {
                        SwingUtilities.invokeLater(() -> {
                            MainFrame.this.pnlChat.setEnabled(true);
                            MainFrame.this.btnSend.setEnabled(true);
                            MainFrame.this.pbWait.setVisible(false);
                            MainFrame.this.tfUserMsg.setEnabled(true);
                            MainFrame.this.tfUserMsg.requestFocusInWindow();
                            MainFrame.this.scrollToBottom();
                        });
                    } else {
                        MainFrame.this.pnlChat.setEnabled(false);
                        MainFrame.this.btnSend.setEnabled(false);
                        MainFrame.this.pbWait.setVisible(false);
                        MainFrame.this.tfUserMsg.setEnabled(false);
                        MainFrame.this.tfUserMsg.requestFocusInWindow();
                        MainFrame.this.scrollToBottom();
                    }
                    if (response.isChatbotWaiting()) {
                        SwingUtilities.invokeLater(() -> {
                            MainFrame.this.tfUserMsg.setText("...");
                            MainFrame.this.btnSend.doClick();
                        });
                    }
                    MainFrame.this.pnlChat.revalidate();
                    MainFrame.this.pnlChat.repaint();
                } else if (response != null) {
                    SwingUtilities.invokeLater(() -> {
                        ErrorMessage pnl = new ErrorMessage();
                        pnl.setMessage("Error while sending the message", System.currentTimeMillis());
                        MainFrame.this.pnlChat.add(pnl);
                        MainFrame.this.pnlChat.revalidate();
                        MainFrame.this.pnlChat.repaint();
                    });
                }
            }
        });
        this.btnSend.setEnabled(false);
        GroupLayout gl_panel = new GroupLayout(panel);
        gl_panel.setHorizontalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, gl_panel.createSequentialGroup().addGap(1).addComponent(this.tfUserMsg, -1, 318, Short.MAX_VALUE).addGap(3).addComponent(this.btnSend).addGap(1)));
        gl_panel.setVerticalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfUserMsg, -1, 23, Short.MAX_VALUE).addComponent(this.btnSend)).addGap(1)));
        panel.setLayout(gl_panel);
        this.spChat = new JScrollPane();
        this.spChat.setVerticalScrollBarPolicy(22);
        this.spChat.setHorizontalScrollBarPolicy(31);
        this.contentPane.add((Component)this.spChat, "Center");
        this.pnlChat = new JPanel();
        this.pnlChat.setBackground(UIManager.getColor("window"));
        this.spChat.setViewportView(this.pnlChat);
        this.pnlChat.setLayout(new BoxLayout(this.pnlChat, 1));
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MainFrame frame = new MainFrame();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

