/*
 * Decompiled with CFR 0.152.
 */
package chatclient;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ServerConnector {
    private static final int API_TIMEOUT = 120;
    private final String key1;
    private final String key2;
    private final String botUrl;
    private final HttpClient httpClient;
    private String serverToken;

    public ServerConnector(String key1, String key2, String botUrl) {
        this.key1 = key1;
        this.key2 = key2;
        this.botUrl = this.normalizeUrl(botUrl);
        this.httpClient = this.createHttpClient();
        this.serverToken = null;
    }

    private String normalizeUrl(String url) {
        if (url == null || url.trim().isEmpty()) {
            throw new IllegalArgumentException("URL cannot be null or empty");
        }
        return url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    private HttpClient createHttpClient() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLContext.setDefault(sslContext);
            SSLParameters sslParameters = new SSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm(null);
            HostnameVerifier allHostsValid = (hostname, session) -> true;
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            return HttpClient.newBuilder().sslContext(sslContext).sslParameters(sslParameters).connectTimeout(Duration.ofSeconds(120L)).version(HttpClient.Version.HTTP_1_1).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create HTTP client with SSL bypass", e);
        }
    }

    public boolean login() {
        ApiResponse apiResponse;
        block4: {
            if (this.serverToken != null) {
                System.err.println("Already logged in!");
                return true;
            }
            try {
                Map<String, String> formData = Map.of("key1", this.key1, "key2", this.key2);
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.botUrl + "/login")).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(this.buildQueryString(formData))).timeout(Duration.ofSeconds(120L)).build();
                HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                apiResponse = this.parseResponseWithAdditionalFields(response.body());
                if (apiResponse == null || !apiResponse.isSuccess() || apiResponse.getToken() == null) break block4;
                this.serverToken = apiResponse.getToken();
                return true;
            }
            catch (Exception e) {
                System.err.println("Login error: " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
        System.err.println("Login failed. Status: " + String.valueOf(apiResponse != null ? Boolean.valueOf(apiResponse.isSuccess()) : "null"));
        this.serverToken = null;
        return false;
    }

    public boolean logout() {
        if (this.serverToken == null) {
            return true;
        }
        try {
            Map<String, String> formData = Map.of("token", this.serverToken);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.botUrl + "/logout")).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(this.buildQueryString(formData))).timeout(Duration.ofSeconds(120L)).build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            this.serverToken = null;
            return true;
        }
        catch (Exception e) {
            System.err.println("Logout error: " + e.getMessage());
            this.serverToken = null;
            return false;
        }
    }

    public ApiResponse letsChat(String userId) {
        if (this.serverToken == null) {
            return null;
        }
        try {
            Map<String, String> formData = Map.of("usr_id", userId, "token", this.serverToken);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.botUrl + "/letschat")).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(this.buildQueryString(formData))).timeout(Duration.ofSeconds(120L)).build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            ApiResponse apiResponse = this.parseResponseWithAdditionalFields(response.body());
            return apiResponse != null && apiResponse.isSuccess() ? apiResponse : null;
        }
        catch (Exception e) {
            System.err.println("LetsChat error: " + e.getMessage());
            return null;
        }
    }

    public ApiResponse sendMessage(String userId, String message) {
        if (this.serverToken == null) {
            return null;
        }
        try {
            Map<String, String> formData = Map.of("usr_id", userId, "token", this.serverToken, "message", message);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.botUrl + "/message")).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(this.buildQueryString(formData))).timeout(Duration.ofSeconds(120L)).build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            ApiResponse apiResponse = this.parseResponseWithAdditionalFields(response.body());
            return apiResponse != null && apiResponse.isSuccess() ? apiResponse : null;
        }
        catch (Exception e) {
            System.err.println("SendMessage error: " + e.getMessage());
            return null;
        }
    }

    private String buildQueryString(Map<String, String> parameters) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (result.length() > 0) {
                result.append("&");
            }
            result.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8)).append("=").append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8));
        }
        return result.toString();
    }

    private ApiResponse parseResponseWithAdditionalFields(String jsonResponse) {
        if (jsonResponse == null || jsonResponse.trim().isEmpty()) {
            return null;
        }
        try {
            JsonObject jsonObject = JsonParser.parseString(jsonResponse).getAsJsonObject();
            String status = jsonObject.has("STATUS") ? jsonObject.get("STATUS").getAsString() : null;
            String token = jsonObject.has("TOKEN") ? jsonObject.get("TOKEN").getAsString() : null;
            boolean chatEnded = jsonObject.has("CHAT_ENDED") ? jsonObject.get("CHAT_ENDED").getAsBoolean() : false;
            String chatState = jsonObject.has("CHAT_STATE") ? jsonObject.get("CHAT_STATE").getAsString() : null;
            String locale = jsonObject.has("LOCALE") ? jsonObject.get("LOCALE").getAsString() : null;
            boolean chatbotWaiting = jsonObject.has("CHATBOT_WAITING") ? jsonObject.get("CHATBOT_WAITING").getAsBoolean() : false;
            String[] messages = null;
            if (jsonObject.has("CHATBOT_MESSAGE")) {
                JsonArray ja = jsonObject.get("CHATBOT_MESSAGE").getAsJsonArray();
                messages = new String[ja.size()];
                int i = 0;
                while (i < ja.size()) {
                    messages[i] = ja.get(i).getAsString();
                    ++i;
                }
            } else {
                messages = new String[]{};
            }
            ApiResponse response = new ApiResponse(status, token, messages, chatEnded, chatState, locale, chatbotWaiting);
            return response;
        }
        catch (Exception e) {
            System.err.println("Failed to parse JSON response: " + e.getMessage());
            return null;
        }
    }

    public boolean isLoggedIn() {
        return this.serverToken != null && !this.serverToken.isEmpty();
    }

    public String getCurrentToken() {
        return this.serverToken;
    }

    public void setToken(String token) {
        this.serverToken = token;
    }

    public ApiResponse parseJsonResponse(String json) {
        return this.parseResponseWithAdditionalFields(json);
    }

    public static class ApiResponse {
        @SerializedName(value="STATUS")
        private String status;
        @SerializedName(value="TOKEN")
        private String token;
        @SerializedName(value="MESSAGES")
        private String[] messages;
        @SerializedName(value="CHAT_ENDED")
        private boolean chatEnded;
        @SerializedName(value="CHAT_STATE")
        private String chatState;
        @SerializedName(value="LOCALE")
        private String locale;
        @SerializedName(value="CHATBOT_WAITING")
        private boolean chatbotWaiting;

        public ApiResponse() {
        }

        public ApiResponse(String status, String token, String[] messages, boolean chatEnded, String chatState, String locale, boolean chatbotWaiting) {
            this.status = status;
            this.token = token;
            this.messages = messages;
            this.chatEnded = chatEnded;
            this.chatState = chatState;
            this.locale = locale;
            this.chatbotWaiting = chatbotWaiting;
        }

        public String getToken() {
            return this.token;
        }

        public boolean isSuccess() {
            return "OK".equals(this.status);
        }

        public boolean isChatEnded() {
            return this.chatEnded;
        }

        public boolean isChatbotWaiting() {
            return this.chatbotWaiting;
        }

        public String getChatState() {
            return this.chatState;
        }

        public String[] getMessages() {
            return this.messages;
        }

        public String getLocale() {
            return this.locale;
        }

        public String getChatStateIconName() {
            if (this.chatState != null) {
                if (this.chatState.equals("AIMODEL")) {
                    return "assistant";
                }
                if (this.chatState.equals("AGENT")) {
                    return "agent";
                }
                if (this.chatState.equals("CHATBOT")) {
                    return "chatbot";
                }
            }
            return null;
        }

        public String toString() {
            return "ApiResponse{status='" + this.status + "', token='" + this.token + "', messages=" + Arrays.toString(this.messages) + ", chatEnded=" + this.chatEnded + ", chatState='" + this.chatState + "', locale='" + this.locale + "', chatbotWaiting=" + this.chatbotWaiting + "}";
        }
    }
}

