package chatclient;

import java.awt.BorderLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.GroupLayout;
import javax.swing.GroupLayout.Alignment;
import javax.swing.JTextField;
import javax.swing.JLabel;
import javax.swing.LayoutStyle.ComponentPlacement;
import javax.swing.JToggleButton;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.JPasswordField;

public class ConnectDialog extends JDialog {

	private static final long serialVersionUID = 1L;

	private boolean cancelled = true;

	private final JPanel contentPanel = new JPanel();
	private JTextField tfIp;
	private JTextField tfPort;
	private JPasswordField tfKey1;
	private JPasswordField tfKey2;
	private JButton okButton;
	private JButton cancelButton;

	/**
	 * Create the dialog.
	 */
	public ConnectDialog() {
		setModal(true);
		setModalityType(ModalityType.APPLICATION_MODAL);
		setTitle("Chat bot server connection");
		setBounds(100, 100, 482, 243);
		getContentPane().setLayout(new BorderLayout());
		contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		getContentPane().add(contentPanel, BorderLayout.CENTER);

		tfIp = new JTextField();
		tfIp.setText("localhost");
		tfIp.setColumns(10);

		JLabel lblNewLabel = new JLabel("Server IP: ");

		tfPort = new JTextField();
		tfPort.setText("8443");
		tfPort.setColumns(10);

		JLabel lblNewLabel_1 = new JLabel("Server port: ");

		tfKey1 = new JPasswordField();
		tfKey1.setText("");
		tfKey1.setColumns(10);

		JLabel lblNewLabel_2 = new JLabel("Key #1: ");

		tfKey2 = new JPasswordField();
		tfKey2.setText("");
		tfKey2.setColumns(10);

		JLabel lblNewLabel_3 = new JLabel("Key #2: ");
		GroupLayout gl_contentPanel = new GroupLayout(contentPanel);
		gl_contentPanel.setHorizontalGroup(
			gl_contentPanel.createParallelGroup(Alignment.LEADING)
				.addGroup(gl_contentPanel.createSequentialGroup()
					.addContainerGap()
					.addGroup(gl_contentPanel.createParallelGroup(Alignment.TRAILING)
						.addComponent(lblNewLabel_2)
						.addComponent(lblNewLabel_1)
						.addComponent(lblNewLabel)
						.addComponent(lblNewLabel_3))
					.addPreferredGap(ComponentPlacement.UNRELATED)
					.addGroup(gl_contentPanel.createParallelGroup(Alignment.LEADING)
						.addComponent(tfPort, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
						.addComponent(tfKey1, GroupLayout.DEFAULT_SIZE, 364, Short.MAX_VALUE)
						.addComponent(tfKey2, GroupLayout.DEFAULT_SIZE, 364, Short.MAX_VALUE)
						.addComponent(tfIp, GroupLayout.PREFERRED_SIZE, 179, GroupLayout.PREFERRED_SIZE))
					.addContainerGap())
		);
		gl_contentPanel.setVerticalGroup(
			gl_contentPanel.createParallelGroup(Alignment.LEADING)
				.addGroup(gl_contentPanel.createSequentialGroup()
					.addGap(6)
					.addGroup(gl_contentPanel.createParallelGroup(Alignment.BASELINE)
						.addComponent(tfIp, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
						.addComponent(lblNewLabel))
					.addPreferredGap(ComponentPlacement.RELATED)
					.addGroup(gl_contentPanel.createParallelGroup(Alignment.BASELINE)
						.addComponent(lblNewLabel_1)
						.addComponent(tfPort, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
					.addPreferredGap(ComponentPlacement.RELATED)
					.addGroup(gl_contentPanel.createParallelGroup(Alignment.BASELINE)
						.addComponent(tfKey1, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
						.addComponent(lblNewLabel_2))
					.addPreferredGap(ComponentPlacement.RELATED)
					.addGroup(gl_contentPanel.createParallelGroup(Alignment.BASELINE)
						.addComponent(tfKey2, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
						.addComponent(lblNewLabel_3))
					.addContainerGap(6, Short.MAX_VALUE))
		);
		contentPanel.setLayout(gl_contentPanel);
		{
			JPanel buttonPane = new JPanel();
			getContentPane().add(buttonPane, BorderLayout.SOUTH);

			JToggleButton tglShowPswd = new JToggleButton("Show password");
			tglShowPswd.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if(tglShowPswd.isSelected()) {
						tfKey1.setEchoChar((char)0);
						tfKey2.setEchoChar((char)0);
					} else {
						tfKey1.setEchoChar('●');
						tfKey2.setEchoChar('●');
					}
				}
			});
			{
				okButton = new JButton("OK");
				okButton.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						// TODO : Validate inputs
						cancelled = false;
						setVisible(false);
					}
				});
				okButton.setActionCommand("OK");
				getRootPane().setDefaultButton(okButton);
			}
			{
				cancelButton = new JButton("Cancel");
				cancelButton.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent e) {
						cancelled = true;
						setVisible(false);
					}
				});
				cancelButton.setActionCommand("Cancel");
			}
			GroupLayout gl_buttonPane = new GroupLayout(buttonPane);
			gl_buttonPane.setHorizontalGroup(
				gl_buttonPane.createParallelGroup(Alignment.LEADING)
					.addGroup(gl_buttonPane.createSequentialGroup()
						.addGap(3)
						.addComponent(tglShowPswd)
						.addPreferredGap(ComponentPlacement.RELATED, 238, Short.MAX_VALUE)
						.addComponent(okButton)
						.addGap(3)
						.addComponent(cancelButton)
						.addGap(3))
			);
			gl_buttonPane.setVerticalGroup(
				gl_buttonPane.createParallelGroup(Alignment.LEADING)
					.addGroup(gl_buttonPane.createSequentialGroup()
						.addGap(3)
						.addGroup(gl_buttonPane.createParallelGroup(Alignment.LEADING, false)
							.addComponent(tglShowPswd)
							.addGroup(gl_buttonPane.createParallelGroup(Alignment.BASELINE)
								.addComponent(cancelButton)
								.addComponent(okButton)))
						.addGap(3))
			);
			buttonPane.setLayout(gl_buttonPane);
		}

		pack();
	}

	public boolean isCancelled() { return cancelled; }

	public String getHost() { return tfIp.getText(); }
	public int getPort() { return Integer.parseInt(tfPort.getText()); }
	public String getKey1() { return tfKey1.getText(); }
	public String getKey2() { return tfKey2.getText(); }
}
