/*
 * Decompiled with CFR 0.152.
 */
package io.github.emmrida.jvsplit;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.formdev.flatlaf.FlatDarkLaf;
import io.github.emmrida.jvsplit.TimelineComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import uk.co.caprica.vlcj.factory.discovery.NativeDiscovery;
import uk.co.caprica.vlcj.factory.discovery.strategy.NativeDiscoveryStrategy;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.MediaPlayerEventAdapter;
import uk.co.caprica.vlcj.player.base.State;
import uk.co.caprica.vlcj.player.component.EmbeddedMediaPlayerComponent;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;

public class MainWindow
extends JFrame {
    private ProjectModel currentProject;
    private File currentProjectFile = null;
    private boolean isDirty = false;
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private boolean isPreviewingAll = false;
    private int currentPreviewIndex = -1;
    private final EmbeddedMediaPlayerComponent mediaPlayerComponent;
    private TimelineComponent timelineComponent;
    private JButton btnPlayPause;
    private static final String TITLE = "Java Video Splitter";

    public MainWindow() {
        super(TITLE);
        this.setJMenuBar(this.createMenuBar());
        this.setLayout(new BorderLayout());
        this.mediaPlayerComponent = new EmbeddedMediaPlayerComponent();
        this.add((Component)this.mediaPlayerComponent, "Center");
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BoxLayout(southPanel, 1));
        southPanel.add(this.createPlaybackToolbar());
        southPanel.add(this.createTimelinePanel());
        southPanel.add(this.createActionToolbar());
        this.add((Component)southPanel, "South");
        this.setSize(800, 600);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(0);
        this.setupWindowEvents();
        this.setupMediaPlayerEvents();
        this.resetProjectState();
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem newItem = new JMenuItem("New Project");
        newItem.addActionListener(e -> this.actionNewProject());
        JMenuItem openItem = new JMenuItem("Open Project");
        openItem.addActionListener(e -> this.actionOpenProject());
        JMenuItem saveItem = new JMenuItem("Save Project");
        saveItem.addActionListener(e -> this.actionSaveProject(false));
        JMenuItem saveAsItem = new JMenuItem("Save Project As...");
        saveAsItem.addActionListener(e -> this.actionSaveProject(true));
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.addActionListener(e -> {
            if (this.checkSaveNeeded()) {
                this.mediaPlayerComponent.release();
                System.exit(0);
            }
        });
        fileMenu.add(newItem);
        fileMenu.add(openItem);
        fileMenu.add(saveItem);
        fileMenu.add(saveAsItem);
        fileMenu.addSeparator();
        fileMenu.add(exitItem);
        JMenu helpMenu = new JMenu("Help");
        JMenuItem guideItem = new JMenuItem("User Guide");
        guideItem.addActionListener(e -> this.showUserGuide());
        JMenuItem aboutItem = new JMenuItem("About");
        aboutItem.addActionListener(e -> this.showAboutDialog());
        helpMenu.add(guideItem);
        helpMenu.add(aboutItem);
        menuBar.add(fileMenu);
        menuBar.add(helpMenu);
        return menuBar;
    }

    private JPanel createPlaybackToolbar() {
        JPanel panel = new JPanel(new FlowLayout(1, 5, 5));
        panel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.DARK_GRAY));
        JButton btnStart = new JButton("\u23ee Start");
        JButton btnBack5s = new JButton("\u23ea -5s");
        JButton btnBack1s = new JButton("\u25c0 -1s");
        JButton btnBack01s = new JButton("\u25c1 -0.1s");
        this.btnPlayPause = new JButton("\u25b6 Play");
        JButton btnFwd01s = new JButton("+0.1s \u25b7");
        JButton btnFwd1s = new JButton("+1s \u25b6");
        JButton btnFwd5s = new JButton("+5s \u23e9");
        JButton btnEnd = new JButton("End \u23ed");
        btnStart.addActionListener(e -> {
            this.mediaPlayerComponent.mediaPlayer().controls().setTime(0L);
            this.stopPreviewMode();
        });
        btnBack5s.addActionListener(e -> this.skip(-5000L));
        btnBack1s.addActionListener(e -> this.skip(-1000L));
        btnBack01s.addActionListener(e -> this.skip(-100L));
        this.btnPlayPause.addActionListener(e -> this.togglePlayPause());
        btnFwd01s.addActionListener(e -> this.skip(100L));
        btnFwd1s.addActionListener(e -> this.skip(1000L));
        btnFwd5s.addActionListener(e -> this.skip(5000L));
        btnEnd.addActionListener(e -> {
            this.mediaPlayerComponent.mediaPlayer().controls().setTime(this.mediaPlayerComponent.mediaPlayer().status().length());
            this.stopPreviewMode();
        });
        panel.add(btnStart);
        panel.add(btnBack5s);
        panel.add(btnBack1s);
        panel.add(btnBack01s);
        panel.add(this.btnPlayPause);
        panel.add(btnFwd01s);
        panel.add(btnFwd1s);
        panel.add(btnFwd5s);
        panel.add(btnEnd);
        return panel;
    }

    private JPanel createTimelinePanel() {
        this.timelineComponent = new TimelineComponent(seekTime -> {
            this.mediaPlayerComponent.mediaPlayer().controls().setTime((long)seekTime);
            this.stopPreviewMode();
        }, segment -> this.playSelection((TimelineComponent.Segment)segment), () -> this.startPreviewAll(), () -> this.markSelection());
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        wrapper.add((Component)this.timelineComponent, "Center");
        return wrapper;
    }

    private JPanel createActionToolbar() {
        JPanel panel = new JPanel(new FlowLayout(1, 5, 5));
        panel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.DARK_GRAY));
        JButton btnNew = new JButton("New Project");
        JButton btnOpen = new JButton("Open Project");
        JButton btnSave = new JButton("Save Project");
        JButton btnExportSingle = new JButton("Export Single File");
        JButton btnExportMulti = new JButton("Export Multi-Files");
        JButton btnMarkCut = new JButton("\u2702 Mark Selection");
        btnMarkCut.setForeground(new Color(255, 100, 100));
        btnNew.addActionListener(e -> this.actionNewProject());
        btnOpen.addActionListener(e -> this.actionOpenProject());
        btnSave.addActionListener(e -> this.actionSaveProject(false));
        btnExportSingle.addActionListener(e -> this.actionExport(true));
        btnExportMulti.addActionListener(e -> this.actionExport(false));
        btnMarkCut.addActionListener(e -> this.markSelection());
        panel.add(btnNew);
        panel.add(btnOpen);
        panel.add(btnSave);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(btnMarkCut);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(btnExportSingle);
        panel.add(btnExportMulti);
        return panel;
    }

    private void skip(long deltaMs) {
        EmbeddedMediaPlayer player = this.mediaPlayerComponent.mediaPlayer();
        long current = player.status().time();
        long length = player.status().length();
        long target = current + deltaMs;
        if (target < 0L) {
            target = 0L;
        }
        if (target > length) {
            target = length;
        }
        player.controls().setTime(target);
        this.timelineComponent.setCurrentTime(target);
        this.stopPreviewMode();
    }

    private void togglePlayPause() {
        EmbeddedMediaPlayer player = this.mediaPlayerComponent.mediaPlayer();
        if (player.status().state() == State.STOPPED || player.status().time() >= player.status().length()) {
            player.controls().setTime(0L);
            player.controls().play();
            return;
        }
        if (player.status().isPlaying()) {
            player.controls().pause();
        } else {
            player.controls().play();
        }
    }

    private void markSelection() {
        long total = this.mediaPlayerComponent.mediaPlayer().status().length();
        long now = this.mediaPlayerComponent.mediaPlayer().status().time();
        long duration = (long)((double)total * 0.05);
        if (duration < 2000L) {
            duration = 2000L;
        }
        if (duration > 30000L) {
            duration = 30000L;
        }
        long start = now;
        long end = now + duration;
        if (end > total) {
            end = total;
        }
        if (this.timelineComponent.isOverlapping(start, end)) {
            JOptionPane.showMessageDialog(this, "Cannot mark here: Overlaps with existing segment.", "Overlap", 2);
            return;
        }
        this.timelineComponent.addSegment(start, end);
        this.isDirty = true;
        this.updateTitle();
    }

    private void playSelection(TimelineComponent.Segment segment) {
        this.stopPreviewMode();
        this.mediaPlayerComponent.mediaPlayer().controls().setTime(segment.start);
        this.mediaPlayerComponent.mediaPlayer().controls().play();
    }

    private void startPreviewAll() {
        List<TimelineComponent.Segment> segs = this.timelineComponent.getSegments();
        if (segs.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No segments to play!");
            return;
        }
        this.isPreviewingAll = true;
        this.currentPreviewIndex = 0;
        this.mediaPlayerComponent.mediaPlayer().controls().setTime(segs.get((int)0).start);
        this.mediaPlayerComponent.mediaPlayer().controls().play();
    }

    private void stopPreviewMode() {
        if (this.isPreviewingAll) {
            this.isPreviewingAll = false;
            this.currentPreviewIndex = -1;
        }
    }

    private void setupWindowEvents() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (MainWindow.this.checkSaveNeeded()) {
                    MainWindow.this.mediaPlayerComponent.release();
                    System.exit(0);
                }
            }
        });
    }

    private void setupMediaPlayerEvents() {
        this.mediaPlayerComponent.mediaPlayer().events().addMediaPlayerEventListener(new MediaPlayerEventAdapter(){

            @Override
            public void lengthChanged(MediaPlayer mediaPlayer, long newLength) {
                SwingUtilities.invokeLater(() -> {
                    MainWindow.this.timelineComponent.setTotalDuration(newLength);
                    if (MainWindow.this.currentProject != null && MainWindow.this.currentProject.segments != null) {
                        MainWindow.this.timelineComponent.clearSegments();
                        for (ProjectModel.Segment seg : MainWindow.this.currentProject.segments) {
                            MainWindow.this.timelineComponent.addSegment(seg.start, seg.end);
                        }
                        MainWindow.this.timelineComponent.repaint();
                    }
                });
            }

            @Override
            public void timeChanged(MediaPlayer mediaPlayer, long newTime) {
                SwingUtilities.invokeLater(() -> MainWindow.this.timelineComponent.setCurrentTime(newTime));
                if (MainWindow.this.isPreviewingAll && MainWindow.this.currentPreviewIndex >= 0) {
                    List<TimelineComponent.Segment> segs = MainWindow.this.timelineComponent.getSegments();
                    if (MainWindow.this.currentPreviewIndex >= segs.size()) {
                        MainWindow.this.stopPreviewMode();
                        mediaPlayer.controls().pause();
                        return;
                    }
                    TimelineComponent.Segment currentSeg = segs.get(MainWindow.this.currentPreviewIndex);
                    if (newTime >= currentSeg.end) {
                        SwingUtilities.invokeLater(() -> {
                            ++MainWindow.this.currentPreviewIndex;
                            if (MainWindow.this.currentPreviewIndex < segs.size()) {
                                TimelineComponent.Segment nextSeg = (TimelineComponent.Segment)segs.get(MainWindow.this.currentPreviewIndex);
                                mediaPlayer.controls().setTime(nextSeg.start);
                            } else {
                                mediaPlayer.controls().pause();
                                MainWindow.this.stopPreviewMode();
                                JOptionPane.showMessageDialog(MainWindow.this, "Preview Complete");
                            }
                        });
                    }
                }
            }

            @Override
            public void finished(MediaPlayer mediaPlayer) {
                SwingUtilities.invokeLater(() -> {
                    MainWindow.this.btnPlayPause.setText("\u21ba Replay");
                    long total = mediaPlayer.status().length();
                    MainWindow.this.timelineComponent.setCurrentTime(total);
                    MainWindow.this.stopPreviewMode();
                });
            }

            @Override
            public void paused(MediaPlayer mediaPlayer) {
                SwingUtilities.invokeLater(() -> MainWindow.this.btnPlayPause.setText("\u25b6 Play"));
            }

            @Override
            public void playing(MediaPlayer mediaPlayer) {
                SwingUtilities.invokeLater(() -> MainWindow.this.btnPlayPause.setText("|| Pause"));
            }
        });
    }

    private void actionNewProject() {
        if (!this.checkSaveNeeded()) {
            return;
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Select Video for New Project");
        fileChooser.setFileFilter(new FileNameExtensionFilter("Video Files", "mp4", "mkv", "avi", "mov"));
        if (fileChooser.showOpenDialog(this) == 0) {
            File videoFile = fileChooser.getSelectedFile();
            this.currentProject = new ProjectModel();
            this.currentProject.videoPath = videoFile.getAbsolutePath();
            this.loadProjectIntoUI();
        }
    }

    private void actionOpenProject() {
        if (!this.checkSaveNeeded()) {
            return;
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Open Project File");
        fileChooser.setFileFilter(new FileNameExtensionFilter("JVSplit Project", "jvs"));
        if (fileChooser.showOpenDialog(this) == 0) {
            try {
                File file = fileChooser.getSelectedFile();
                this.currentProject = (ProjectModel)this.jsonMapper.readValue(file, ProjectModel.class);
                this.currentProjectFile = file;
                this.loadProjectIntoUI();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Failed to load: " + e.getMessage());
            }
        }
    }

    private void actionSaveProject(boolean saveAs) {
        if (this.currentProject == null) {
            return;
        }
        this.currentProject.segments.clear();
        List<TimelineComponent.Segment> uiSegments = this.timelineComponent.getSegments();
        for (TimelineComponent.Segment uiSeg : uiSegments) {
            this.currentProject.segments.add(new ProjectModel.Segment(uiSeg.start, uiSeg.end));
        }
        if (this.currentProjectFile != null && !saveAs) {
            this.saveToDisk(this.currentProjectFile);
        } else {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Save Project");
            fileChooser.setFileFilter(new FileNameExtensionFilter("JVSplit Project", "jvs"));
            if (fileChooser.showSaveDialog(this) == 0) {
                int res;
                File file = fileChooser.getSelectedFile();
                if (!file.getName().endsWith(".json")) {
                    file = new File(file.getAbsolutePath() + ".json");
                }
                if (file.exists() && (res = JOptionPane.showConfirmDialog(this, "File exists. Overwrite?", "Confirm", 0)) != 0) {
                    return;
                }
                this.saveToDisk(file);
            }
        }
    }

    private void saveToDisk(File file) {
        try {
            this.jsonMapper.writerWithDefaultPrettyPrinter().writeValue(file, (Object)this.currentProject);
            this.currentProjectFile = file;
            this.isDirty = false;
            this.updateTitle();
            if (this.currentProjectFile == file) {
                System.out.println("Project saved.");
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error saving: " + e.getMessage());
        }
    }

    private boolean checkSaveNeeded() {
        if (this.isDirty && this.currentProject != null) {
            int result = JOptionPane.showConfirmDialog(this, "You have unsaved changes. Save now?", "Unsaved Changes", 1);
            if (result == 0) {
                this.actionSaveProject(false);
                return !this.isDirty;
            }
            return result == 1;
        }
        return true;
    }

    private void loadProjectIntoUI() {
        if (this.currentProject == null) {
            return;
        }
        this.resetProjectState(false);
        this.mediaPlayerComponent.mediaPlayer().media().play(this.currentProject.videoPath, new String[0]);
        this.mediaPlayerComponent.mediaPlayer().controls().setPause(true);
        this.isDirty = false;
        this.updateTitle();
    }

    private void resetProjectState() {
        this.resetProjectState(true);
    }

    private void resetProjectState(boolean fullReset) {
        if (fullReset) {
            this.currentProject = null;
            this.currentProjectFile = null;
            this.isDirty = false;
        }
        if (this.timelineComponent != null) {
            this.timelineComponent.clearSegments();
        }
        this.updateTitle();
        if (fullReset && this.mediaPlayerComponent != null) {
            this.mediaPlayerComponent.mediaPlayer().controls().stop();
        }
    }

    private void updateTitle() {
        Object title = TITLE;
        if (this.currentProject != null) {
            File f = new File(this.currentProject.videoPath);
            title = (String)title + " - " + f.getName();
        }
        if (this.isDirty) {
            title = (String)title + " *";
        }
        this.setTitle((String)title);
    }

    private void actionExport(boolean singleFile) {
        if (this.currentProject == null || this.timelineComponent.getSegments().isEmpty()) {
            JOptionPane.showMessageDialog(this, "No segments to export!");
            return;
        }
        List<TimelineComponent.Segment> segments = this.timelineComponent.getSegments();
        String inputPath = this.currentProject.videoPath;
        File sourceFile = new File(inputPath);
        String defaultName = sourceFile.getName().substring(0, sourceFile.getName().lastIndexOf(46));
        if (singleFile) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Save Merged Video");
            fileChooser.setSelectedFile(new File(defaultName + "_merged.mp4"));
            if (fileChooser.showSaveDialog(this) == 0) {
                File dest = fileChooser.getSelectedFile();
                if (dest.exists() && JOptionPane.showConfirmDialog(this, "File exists. Overwrite?", "Confirm", 0) != 0) {
                    return;
                }
                this.runExportWorker(true, inputPath, dest, null, segments);
            }
        } else {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Select Output Folder");
            fileChooser.setFileSelectionMode(1);
            if (fileChooser.showSaveDialog(this) == 0) {
                int res;
                File outDir = fileChooser.getSelectedFile();
                String baseName = JOptionPane.showInputDialog(this, "Enter base filename for parts:", defaultName);
                if (baseName == null || baseName.trim().isEmpty()) {
                    return;
                }
                boolean collision = false;
                int i = 1;
                while (i <= segments.size()) {
                    File check = new File(outDir, String.format("%s_part%03d.mp4", baseName, i));
                    if (check.exists()) {
                        collision = true;
                        break;
                    }
                    ++i;
                }
                if (collision && (res = JOptionPane.showConfirmDialog(this, "One or more files already exist. Overwrite ALL?", "Confirm Batch Overwrite", 0)) != 0) {
                    return;
                }
                this.runExportWorker(false, inputPath, outDir, baseName, segments);
            }
        }
    }

    private JDialog createProcessingDialog() {
        JDialog dialog = new JDialog(this, "Processing", true);
        dialog.setLayout(new BorderLayout());
        JPanel content = new JPanel();
        content.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        content.setLayout(new BoxLayout(content, 1));
        JLabel lblMsg = new JLabel("Exporting video... Please wait.");
        lblMsg.setAlignmentX(0.5f);
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        progressBar.setPreferredSize(new Dimension(250, 20));
        content.add(lblMsg);
        content.add(Box.createVerticalStrut(15));
        content.add(progressBar);
        dialog.add((Component)content, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setDefaultCloseOperation(0);
        return dialog;
    }

    private void runExportWorker(final boolean singleFile, final String input, final File dest, final String baseName, final List<TimelineComponent.Segment> segs) {
        final JDialog loadingDialog = this.createProcessingDialog();
        SwingWorker<Void, String> worker = new SwingWorker<Void, String>(){

            @Override
            protected Void doInBackground() throws Exception {
                this.publish("Starting export...");
                if (singleFile) {
                    this.exportSingleFile(input, dest, segs);
                } else {
                    this.exportMultipleFiles(input, dest, baseName, segs);
                }
                return null;
            }

            @Override
            protected void process(List<String> chunks) {
                for (String msg : chunks) {
                    System.out.println("[Export] " + msg);
                }
            }

            @Override
            protected void done() {
                loadingDialog.dispose();
                try {
                    this.get();
                    int choice = JOptionPane.showConfirmDialog(MainWindow.this, "Export complete! Open location?", "Success", 0);
                    if (choice == 0) {
                        MainWindow.this.openInDefaultPlayer(singleFile ? dest : dest);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(MainWindow.this, "Export Failed:\n" + e.getMessage(), "Error", 0);
                }
            }

            private void exportMultipleFiles(String input2, File outDir, String baseName2, List<TimelineComponent.Segment> segs2) throws Exception {
                int index = 1;
                for (TimelineComponent.Segment seg : segs2) {
                    String outName = String.format("%s_part%03d.mp4", baseName2, index++);
                    File outFile = new File(outDir, outName);
                    this.publish("Exporting: " + outName);
                    ArrayList<String> cmd = new ArrayList<String>();
                    cmd.add("ffmpeg");
                    cmd.add("-y");
                    cmd.add("-i");
                    cmd.add(input2);
                    cmd.add("-ss");
                    cmd.add(MainWindow.this.formatTimeFFmpeg(seg.start));
                    cmd.add("-to");
                    cmd.add(MainWindow.this.formatTimeFFmpeg(seg.end));
                    cmd.add("-c:v");
                    cmd.add("libx264");
                    cmd.add("-preset");
                    cmd.add("ultrafast");
                    cmd.add("-c:a");
                    cmd.add("aac");
                    cmd.add(outFile.getAbsolutePath());
                    this.runFFmpeg(cmd);
                }
            }

            private void exportSingleFile(String input2, File outFile, List<TimelineComponent.Segment> segs2) throws Exception {
                File listFile = File.createTempFile("ffmpeg_list", ".txt");
                PrintWriter writer = new PrintWriter(listFile);
                String cleanPath = input2.replace("\\", "/");
                for (TimelineComponent.Segment seg : segs2) {
                    writer.println("file '" + cleanPath + "'");
                    writer.println("inpoint " + MainWindow.this.formatTimeFFmpeg(seg.start));
                    writer.println("outpoint " + MainWindow.this.formatTimeFFmpeg(seg.end));
                }
                writer.close();
                this.publish("Merging segments...");
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add("ffmpeg");
                cmd.add("-y");
                cmd.add("-f");
                cmd.add("concat");
                cmd.add("-safe");
                cmd.add("0");
                cmd.add("-i");
                cmd.add(listFile.getAbsolutePath());
                cmd.add("-c:v");
                cmd.add("libx264");
                cmd.add("-preset");
                cmd.add("ultrafast");
                cmd.add("-c:a");
                cmd.add("aac");
                cmd.add(outFile.getAbsolutePath());
                this.runFFmpeg(cmd);
                listFile.delete();
            }

            private void runFFmpeg(List<String> cmd) throws Exception {
                ProcessBuilder pb = new ProcessBuilder(cmd);
                pb.redirectErrorStream(true);
                Process p = pb.start();
                Throwable throwable = null;
                Object var5_6 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                    while (reader.readLine() != null) {
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                if (p.waitFor() != 0) {
                    throw new RuntimeException("FFmpeg failed");
                }
            }
        };
        worker.execute();
        loadingDialog.setVisible(true);
    }

    private String formatTimeFFmpeg(long millis) {
        long hours = millis / 3600000L;
        long minutes = millis % 3600000L / 60000L;
        long seconds = millis % 60000L / 1000L;
        long ms = millis % 1000L;
        return String.format("%02d:%02d:%02d.%03d", hours, minutes, seconds, ms);
    }

    private void openInDefaultPlayer(File file) {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showUserGuide() {
        JOptionPane.showMessageDialog(this, "1. File > New Project to open video.\n2. Click 'Mark Selection' or Right-Click timeline.\n3. Right-Click segments to edit/remove.\n4. Export when done.", "Guide", 1);
    }

    private void showAboutDialog() {
        JOptionPane.showMessageDialog(this, "Java Video Splitter v1.0\nPowered by VLCJ & FFmpeg", "About", 1);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new FlatDarkLaf());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new NativeDiscovery(new NativeDiscoveryStrategy[0]).discover();
        SwingUtilities.invokeLater(() -> new MainWindow().setVisible(true));
    }

    public static class ProjectModel {
        public String videoPath;
        public List<Segment> segments = new ArrayList<Segment>();

        public static class Segment {
            public long start;
            public long end;

            public Segment() {
            }

            public Segment(long s, long e) {
                this.start = s;
                this.end = e;
            }
        }
    }
}

