/*
 * Decompiled with CFR 0.152.
 */
package io.github.emmrida.jvsplit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class TimelineComponent
extends JComponent {
    private long totalDurationMs = 1L;
    private long currentTimeMs = 0L;
    private List<Segment> segments = new ArrayList<Segment>();
    private Consumer<Long> seekCallback;
    private Consumer<Segment> playRangeCallback;
    private Runnable playAllCallback;
    private Runnable markCurrentCallback;
    private static final int HEIGHT = 80;
    private static final int RULER_H = 20;
    private static final int TRACK_H = 40;
    private static final int TRACK_Y = 30;

    public TimelineComponent(Consumer<Long> seekCallback, Consumer<Segment> playRangeCallback, Runnable playAllCallback, Runnable markCurrentCallback) {
        this.seekCallback = seekCallback;
        this.playRangeCallback = playRangeCallback;
        this.playAllCallback = playAllCallback;
        this.markCurrentCallback = markCurrentCallback;
        this.setPreferredSize(new Dimension(800, 80));
        this.setFont(new Font("SansSerif", 0, 10));
        MouseAdapter mouseHandler = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TimelineComponent.this.handlePopup(e);
                } else if (SwingUtilities.isLeftMouseButton(e)) {
                    TimelineComponent.this.updateTimeFromMouse(e.getX());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TimelineComponent.this.handlePopup(e);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!e.isPopupTrigger() && SwingUtilities.isLeftMouseButton(e)) {
                    TimelineComponent.this.updateTimeFromMouse(e.getX());
                }
            }
        };
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
    }

    public void setTotalDuration(long duration) {
        this.totalDurationMs = duration > 0L ? duration : 1L;
        this.repaint();
    }

    public void setCurrentTime(long time) {
        this.currentTimeMs = time;
        this.repaint();
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public boolean isOverlapping(long start, long end, Segment excludeSegment) {
        for (Segment s : this.segments) {
            if (s == excludeSegment || start >= s.end || end <= s.start) continue;
            return true;
        }
        return false;
    }

    public boolean isOverlapping(long start, long end) {
        return this.isOverlapping(start, end, null);
    }

    public void addSegment(long start, long end) {
        if ((start = Math.max(0L, start)) < (end = Math.min(this.totalDurationMs, end))) {
            this.segments.add(new Segment(start, end));
            Collections.sort(this.segments, Comparator.comparingLong(s -> s.start));
            this.repaint();
        }
    }

    public void clearSegments() {
        this.segments.clear();
        this.repaint();
    }

    private void updateTimeFromMouse(int mouseX) {
        long newTime;
        double percentage = (double)Math.max(0, Math.min(this.getWidth(), mouseX)) / (double)this.getWidth();
        this.currentTimeMs = newTime = (long)(percentage * (double)this.totalDurationMs);
        this.repaint();
        if (this.seekCallback != null) {
            this.seekCallback.accept(newTime);
        }
    }

    private Segment getSegmentAt(int x) {
        double pxPerMs = (double)this.getWidth() / (double)this.totalDurationMs;
        int i = this.segments.size() - 1;
        while (i >= 0) {
            Segment s = this.segments.get(i);
            int startX = (int)((double)s.start * pxPerMs);
            int endX = (int)((double)s.end * pxPerMs);
            if (x >= startX - 2 && x <= endX + 2) {
                return s;
            }
            --i;
        }
        return null;
    }

    private void handlePopup(MouseEvent e) {
        Segment target = this.getSegmentAt(e.getX());
        if (target != null) {
            this.showSegmentPopup(e, target);
        } else {
            this.showBackgroundPopup(e);
        }
    }

    private void showSegmentPopup(MouseEvent e, Segment segment) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem itemStart = new JMenuItem("Set selection start");
        itemStart.addActionListener(ev -> {
            if (this.currentTimeMs < segment.end && !this.isOverlapping(this.currentTimeMs, segment.end, segment)) {
                segment.start = this.currentTimeMs;
                this.repaint();
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        });
        JMenuItem itemEnd = new JMenuItem("Set selection end");
        itemEnd.addActionListener(ev -> {
            if (this.currentTimeMs > segment.start && !this.isOverlapping(segment.start, this.currentTimeMs, segment)) {
                segment.end = this.currentTimeMs;
                this.repaint();
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        });
        JMenuItem itemPlay = new JMenuItem("\u25b6 Play this selection");
        itemPlay.addActionListener(ev -> {
            if (this.playRangeCallback != null) {
                this.playRangeCallback.accept(segment);
            }
        });
        JMenuItem itemRemove = new JMenuItem("\ud83d\uddd1 Remove");
        itemRemove.setForeground(Color.RED);
        itemRemove.addActionListener(ev -> {
            int choice = JOptionPane.showConfirmDialog(this, "Are you sure you want to remove this segment?", "Confirm Removal", 0);
            if (choice == 0) {
                this.segments.remove(segment);
                this.repaint();
            }
        });
        menu.add(itemStart);
        menu.add(itemEnd);
        menu.add(new JSeparator());
        menu.add(itemPlay);
        menu.add(new JSeparator());
        menu.add(itemRemove);
        menu.show(this, e.getX(), e.getY());
    }

    private void showBackgroundPopup(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem itemPlayAll = new JMenuItem("\u25b6\u25b6 Play all selections");
        itemPlayAll.addActionListener(ev -> {
            if (this.playAllCallback != null) {
                this.playAllCallback.run();
            }
        });
        JMenuItem itemMark = new JMenuItem("\u2702 Mark selection here");
        itemMark.addActionListener(ev -> {
            this.updateTimeFromMouse(e.getX());
            if (this.markCurrentCallback != null) {
                this.markCurrentCallback.run();
            }
        });
        menu.add(itemPlayAll);
        menu.add(new JSeparator());
        menu.add(itemMark);
        menu.show(this, e.getX(), e.getY());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = this.getWidth();
        double pxPerMs = (double)w / (double)this.totalDurationMs;
        this.drawRuler(g2, w, pxPerMs);
        g2.setColor(new Color(40, 40, 40));
        g2.fillRoundRect(0, 30, w, 40, 8, 8);
        for (Segment s : this.segments) {
            int x1 = (int)((double)s.start * pxPerMs);
            int x2 = (int)((double)s.end * pxPerMs);
            int segW = Math.max(3, x2 - x1);
            g2.setColor(s.color);
            g2.fillRect(x1, 30, segW, 40);
            g2.setColor(s.color.brighter());
            g2.drawRect(x1, 30, segW, 40);
        }
        int playX = (int)((double)this.currentTimeMs * pxPerMs);
        g2.setColor(new Color(255, 69, 58));
        g2.setStroke(new BasicStroke(2.0f));
        g2.drawLine(playX, 0, playX, this.getHeight());
        g2.fillPolygon(new int[]{playX - 5, playX + 5, playX}, new int[]{20, 20, 30}, 3);
    }

    private void drawRuler(Graphics2D g2, int width, double pxPerMs) {
        g2.setColor(Color.GRAY);
        g2.drawLine(0, 20, width, 20);
        double minPxBetweenTicks = 80.0;
        long minMsInterval = (long)(minPxBetweenTicks / pxPerMs);
        long intervalMs = this.getNicelyRoundedInterval(minMsInterval);
        long t = 0L;
        while (t <= this.totalDurationMs) {
            int x = (int)((double)t * pxPerMs);
            if (x > width) break;
            g2.drawLine(x, 0, x, 20);
            String timeStr = this.formatTimeShort(t);
            g2.drawString(timeStr, x + 4, 15);
            t += intervalMs;
        }
    }

    private long getNicelyRoundedInterval(long minMs) {
        long[] steps;
        long[] lArray = steps = new long[]{1000L, 2000L, 5000L, 10000L, 30000L, 60000L, 120000L, 300000L, 600000L, 1800000L, 3600000L};
        int n = steps.length;
        int n2 = 0;
        while (n2 < n) {
            long step = lArray[n2];
            if (step >= minMs) {
                return step;
            }
            ++n2;
        }
        return 3600000L;
    }

    private String formatTimeShort(long ms) {
        long sec = ms / 1000L;
        if (sec < 60L) {
            return sec + "s";
        }
        long min = sec / 60L;
        return min + "m";
    }

    public static class Segment {
        public long start;
        public long end;
        public Color color;

        public Segment(long s, long e) {
            this.start = s;
            this.end = e;
            float hue = new Random().nextFloat();
            this.color = Color.getHSBColor(hue, 0.6f, 0.9f);
        }
    }
}

