/*
 * Decompiled with CFR 0.152.
 */
package chatclient;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;

public class ConnectDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private boolean cancelled = true;
    private final JPanel contentPanel = new JPanel();
    private JTextField tfIp;
    private JTextField tfPort;
    private JPasswordField tfKey1;
    private JPasswordField tfKey2;
    private JButton okButton;
    private JButton cancelButton;

    public ConnectDialog() {
        this.setModal(true);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("Chat bot server connection");
        this.setBounds(100, 100, 482, 243);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.tfIp = new JTextField();
        this.tfIp.setColumns(10);
        JLabel lblNewLabel = new JLabel("Server IP: ");
        this.tfPort = new JTextField();
        this.tfPort.setColumns(10);
        JLabel lblNewLabel_1 = new JLabel("Server port: ");
        this.tfKey1 = new JPasswordField();
        this.tfKey1.setText("");
        this.tfKey1.setColumns(10);
        JLabel lblNewLabel_2 = new JLabel("Key #1: ");
        this.tfKey2 = new JPasswordField();
        this.tfKey2.setText("");
        this.tfKey2.setColumns(10);
        JLabel lblNewLabel_3 = new JLabel("Key #2: ");
        GroupLayout gl_contentPanel = new GroupLayout(this.contentPanel);
        gl_contentPanel.setHorizontalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addContainerGap().addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lblNewLabel_2).addComponent(lblNewLabel_1).addComponent(lblNewLabel).addComponent(lblNewLabel_3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfPort, -2, -1, -2).addComponent(this.tfKey1, -1, 364, Short.MAX_VALUE).addComponent(this.tfKey2, -1, 364, Short.MAX_VALUE).addComponent(this.tfIp, -2, 179, -2)).addContainerGap()));
        gl_contentPanel.setVerticalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addGap(6).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfIp, -2, -1, -2).addComponent(lblNewLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblNewLabel_1).addComponent(this.tfPort, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfKey1, -2, -1, -2).addComponent(lblNewLabel_2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfKey2, -2, -1, -2).addComponent(lblNewLabel_3)).addContainerGap(6, Short.MAX_VALUE)));
        this.contentPanel.setLayout(gl_contentPanel);
        JPanel buttonPane = new JPanel();
        this.getContentPane().add((Component)buttonPane, "South");
        final JToggleButton tglShowPswd = new JToggleButton("Show password");
        tglShowPswd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (tglShowPswd.isSelected()) {
                    ConnectDialog.this.tfKey1.setEchoChar('\u0000');
                    ConnectDialog.this.tfKey2.setEchoChar('\u0000');
                } else {
                    ConnectDialog.this.tfKey1.setEchoChar('\u25cf');
                    ConnectDialog.this.tfKey2.setEchoChar('\u25cf');
                }
            }
        });
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String ip = ConnectDialog.this.tfIp.getText().trim();
                    int port = Integer.parseInt(ConnectDialog.this.tfPort.getText().trim());
                    String key1 = new String(ConnectDialog.this.tfKey1.getPassword());
                    String key2 = new String(ConnectDialog.this.tfKey2.getPassword());
                    if (ip.isEmpty() || port < 1000 || port > 65535 || key1.isEmpty() || key1.length() < 8 || key2.isEmpty() || key2.length() < 8) {
                        throw new Exception("Invalid input.");
                    }
                    Properties props = new Properties();
                    props.put("ip", ip);
                    props.put("port", ConnectDialog.this.tfPort.getText().trim());
                    props.put("key1", key1);
                    props.put("key2", key2);
                    props.store(new FileOutputStream("./config.properties"), "");
                    ConnectDialog.this.cancelled = false;
                    ConnectDialog.this.setVisible(false);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(ConnectDialog.this, ex.getMessage(), "Error", 0);
                }
            }
        });
        this.okButton.setActionCommand("OK");
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectDialog.this.cancelled = true;
                ConnectDialog.this.setVisible(false);
            }
        });
        this.cancelButton.setActionCommand("Cancel");
        GroupLayout gl_buttonPane = new GroupLayout(buttonPane);
        gl_buttonPane.setHorizontalGroup(gl_buttonPane.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_buttonPane.createSequentialGroup().addGap(3).addComponent(tglShowPswd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 238, Short.MAX_VALUE).addComponent(this.okButton).addGap(3).addComponent(this.cancelButton).addGap(3)));
        gl_buttonPane.setVerticalGroup(gl_buttonPane.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_buttonPane.createSequentialGroup().addGap(3).addGroup(gl_buttonPane.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(tglShowPswd).addGroup(gl_buttonPane.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton))).addGap(3)));
        buttonPane.setLayout(gl_buttonPane);
        Properties props = new Properties();
        try {
            props.load(new FileReader("./config.properties"));
            this.tfIp.setText(props.getProperty("ip"));
            this.tfPort.setText(props.getProperty("port"));
            this.tfKey1.setText(props.getProperty("key1"));
            this.tfKey2.setText(props.getProperty("key2"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pack();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getHost() {
        return this.tfIp.getText();
    }

    public int getPort() {
        return Integer.parseInt(this.tfPort.getText());
    }

    public String getKey1() {
        return this.tfKey1.getText();
    }

    public String getKey2() {
        return this.tfKey2.getText();
    }
}

