/*
 * Decompiled with CFR 0.152.
 */
package chatclient;

import chatclient.ConnectDialog;
import chatclient.ErrorMessage;
import chatclient.Helper;
import chatclient.RemoteMessage;
import chatclient.ServerConnector;
import chatclient.UserMessage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private ServerConnector serverConnector = null;
    private boolean isChatbotWaiting = false;
    private JPanel contentPane;
    private JTextField tfUserMsg;
    private JPanel pnlChat;
    private JButton btnSend;
    private JToggleButton tglConnect;
    private JScrollPane spChat;
    private JProgressBar pbWait;
    private Component horizontalStrut;
    private Component horizontalStrut_1;
    private JTextField tfUserName;

    public void onRemoteMsgLinkClicked(String id) {
        int us;
        if (id != null && !id.isBlank() && (us = id.indexOf(95)) >= 0) {
            String response = id.substring(us).replaceAll("_", " ");
            this.tfUserMsg.setText(response);
            this.btnSend.doClick();
        }
    }

    private void setUIMode(UISTATE mode) {
        this.pbWait.setEnabled(false);
        this.tfUserName.setEditable(false);
        this.tfUserMsg.setEnabled(false);
        this.btnSend.setEnabled(false);
        this.pbWait.setVisible(false);
        switch (mode) {
            case LOGOUT: {
                this.tglConnect.setSelected(false);
                this.tfUserName.requestFocus();
                break;
            }
            case DISCONNECTED: {
                this.tglConnect.setSelected(false);
                this.tfUserName.setEditable(true);
                this.tfUserName.requestFocus();
                break;
            }
            case CONNECTED: {
                this.pnlChat.removeAll();
                this.btnSend.setEnabled(true);
                this.tfUserMsg.setEnabled(true);
                break;
            }
            case WAITING: {
                this.pbWait.setVisible(true);
                this.tfUserMsg.setText("");
                break;
            }
            case IDLE: {
                this.btnSend.setEnabled(true);
                this.tfUserMsg.setEnabled(true);
                this.tfUserMsg.requestFocus();
            }
        }
    }

    private void scrollToBottom() {
        final Timer timer = new Timer(10, null);
        ActionListener al = new ActionListener(){
            float steps = -1.0f;

            @Override
            public void actionPerformed(ActionEvent e) {
                JScrollBar bar = MainFrame.this.spChat.getVerticalScrollBar();
                int max = bar.getMaximum() - bar.getVisibleAmount();
                if (this.steps < 0.0f) {
                    this.steps = (max - bar.getValue()) / 10;
                }
                bar.setValue(bar.getValue() + Math.round(this.steps *= 0.915f));
                if (this.steps <= 1.0f) {
                    this.steps = 1.0f;
                }
                if (bar.getValue() >= max) {
                    timer.stop();
                }
            }
        };
        timer.addActionListener(al);
        timer.start();
    }

    public MainFrame() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                ConnectDialog dlg = new ConnectDialog();
                dlg.setLocationRelativeTo(MainFrame.this);
                dlg.setVisible(true);
                if (!dlg.isCancelled()) {
                    MainFrame.this.pbWait.setVisible(true);
                    MainFrame.this.serverConnector = new ServerConnector(dlg.getKey1(), dlg.getKey2(), "https://" + dlg.getHost() + ":" + dlg.getPort());
                    new Thread(() -> {
                        if (MainFrame.this.serverConnector.login()) {
                            SwingUtilities.invokeLater(() -> MainFrame.this.setUIMode(UISTATE.DISCONNECTED));
                        } else {
                            SwingUtilities.invokeLater(() -> {
                                JOptionPane.showMessageDialog(MainFrame.this, "Login failed", "Error", 0);
                                MainFrame.this.dispatchEvent(new WindowEvent(MainFrame.this, 201));
                            });
                        }
                    }).start();
                } else {
                    System.exit(0);
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (!MainFrame.this.serverConnector.logout()) {
                    JOptionPane.showMessageDialog(MainFrame.this, "Logout failed", "Error", 0);
                }
                MainFrame.this.serverConnector = null;
                MainFrame.this.dispose();
                System.exit(0);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setSize(400, 600);
        this.setLocationRelativeTo(null);
        this.setTitle("Chat4Us-Client - Sample Project");
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setBorder(new EtchedBorder(1, null, null));
        this.contentPane.add((Component)toolBar, "North");
        this.tglConnect = new JToggleButton("");
        this.tglConnect.addItemListener(e -> {
            if (this.serverConnector.isLoggedIn()) {
                if (this.tglConnect.isSelected()) {
                    if (this.tfUserName.getText().isEmpty()) {
                        this.tglConnect.setSelected(false);
                        this.tfUserName.requestFocus();
                        JOptionPane.showMessageDialog(this, "Enter user name", "Error", 0);
                        return;
                    }
                    this.pnlChat.removeAll();
                    new Thread(() -> {
                        ServerConnector.ApiResponse response = this.serverConnector.letsChat(this.tfUserName.getText());
                        if (response != null && response.isSuccess()) {
                            String[] messages = response.getMessages();
                            SwingUtilities.invokeLater(() -> {
                                this.setUIMode(UISTATE.CONNECTED);
                                String[] stringArray2 = messages;
                                int n = messages.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String message = stringArray2[n2];
                                    RemoteMessage panel = new RemoteMessage();
                                    panel.setMessage(message, System.currentTimeMillis());
                                    this.pnlChat.add(panel);
                                    this.pnlChat.revalidate();
                                    this.pnlChat.repaint();
                                    ++n2;
                                }
                                if (!response.isChatEnded()) {
                                    this.setUIMode(UISTATE.IDLE);
                                }
                            });
                        } else {
                            SwingUtilities.invokeLater(() -> {
                                this.setUIMode(UISTATE.LOGOUT);
                                JOptionPane.showMessageDialog(this, "Chat start failure", "Error", 0);
                            });
                        }
                    }).start();
                } else {
                    SwingUtilities.invokeLater(() -> this.setUIMode(UISTATE.DISCONNECTED));
                }
            } else {
                JOptionPane.showMessageDialog(this, "User not logged in!", "Error", 0);
            }
        });
        this.tglConnect.setIcon(Helper.loadIconFromResources("/disconnected.png", 20, 20));
        this.tglConnect.setSelectedIcon(Helper.loadIconFromResources("/connected.png", 20, 20));
        this.tglConnect.setFocusable(false);
        toolBar.add(this.tglConnect);
        this.tfUserName = new JTextField();
        this.tfUserName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MainFrame.this.tglConnect.doClick();
                }
            }
        });
        this.tfUserName.setEditable(false);
        this.tfUserName.setColumns(10);
        this.tfUserName.setMaximumSize(new Dimension(128, 20));
        this.tfUserName.setBorder(new EmptyBorder(0, 3, 0, 3));
        toolBar.add(this.tfUserName);
        this.pbWait = new JProgressBar();
        this.pbWait.setVisible(false);
        this.pbWait.setBorder(null);
        this.pbWait.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.horizontalStrut = Box.createHorizontalStrut(20);
        this.horizontalStrut.setPreferredSize(new Dimension(5, 0));
        this.horizontalStrut.setMinimumSize(new Dimension(5, 0));
        toolBar.add(this.horizontalStrut);
        this.pbWait.setIndeterminate(true);
        toolBar.add(this.pbWait);
        this.horizontalStrut_1 = Box.createHorizontalStrut(20);
        this.horizontalStrut_1.setPreferredSize(new Dimension(5, 0));
        this.horizontalStrut_1.setMinimumSize(new Dimension(5, 0));
        toolBar.add(this.horizontalStrut_1);
        JPanel panel = new JPanel();
        panel.setBorder(new EtchedBorder(1, null, null));
        this.contentPane.add((Component)panel, "South");
        this.tfUserMsg = new JTextField();
        this.tfUserMsg.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MainFrame.this.btnSend.doClick();
                }
            }
        });
        this.tfUserMsg.setEnabled(false);
        this.tfUserMsg.setColumns(10);
        this.btnSend = new JButton();
        this.btnSend.setIcon(Helper.loadIconFromResources("/send.png", 20, 20));
        this.btnSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainFrame.this.serverConnector != null && MainFrame.this.serverConnector.isLoggedIn()) {
                    String msg = MainFrame.this.tfUserMsg.getText();
                    if (!msg.isBlank()) {
                        MainFrame.this.setUIMode(UISTATE.WAITING);
                        if (!msg.equals("...") && !MainFrame.this.isChatbotWaiting) {
                            UserMessage panel = new UserMessage();
                            panel.setMessage(Helper.escapeHtml(msg), System.currentTimeMillis());
                            MainFrame.this.pnlChat.add(panel);
                            MainFrame.this.scrollToBottom();
                            MainFrame.this.pnlChat.revalidate();
                            MainFrame.this.pnlChat.repaint();
                        }
                        new Thread(() -> {
                            ServerConnector.ApiResponse response = MainFrame.this.serverConnector.sendMessage(MainFrame.this.tfUserName.getText(), msg);
                            if (response != null) {
                                this.handleServerAnswer(response);
                            } else {
                                SwingUtilities.invokeLater(() -> {
                                    MainFrame.this.setUIMode(UISTATE.DISCONNECTED);
                                    this.appendErrorMessage("Fatal error or disconnected");
                                });
                            }
                        }).start();
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else {
                    MainFrame.this.setUIMode(UISTATE.DISCONNECTED);
                    JOptionPane.showMessageDialog(MainFrame.this, "Your are not logged in. Please close this window and try again.", "Error", 0);
                }
            }

            private void handleServerAnswer(ServerConnector.ApiResponse response) {
                if (response != null && response.isSuccess()) {
                    String[] messages;
                    String[] stringArray = messages = response.getMessages();
                    int n = messages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String message = stringArray[n2];
                        if (!message.isBlank()) {
                            SwingUtilities.invokeLater(() -> {
                                RemoteMessage pnl = new RemoteMessage();
                                pnl.setMessage(message, System.currentTimeMillis());
                                pnl.setIcon("/" + response.getChatStateIconName() + ".png");
                                MainFrame.this.pnlChat.add(pnl);
                            });
                        }
                        ++n2;
                    }
                    if (!response.isChatEnded()) {
                        SwingUtilities.invokeLater(() -> {
                            MainFrame.this.setUIMode(UISTATE.IDLE);
                            MainFrame.this.scrollToBottom();
                        });
                    } else {
                        SwingUtilities.invokeLater(() -> {
                            MainFrame.this.setUIMode(UISTATE.DISCONNECTED);
                            this.appendErrorMessage("This chat has ended.");
                            MainFrame.this.scrollToBottom();
                        });
                    }
                    MainFrame.this.isChatbotWaiting = response.isChatbotWaiting();
                    if (MainFrame.this.isChatbotWaiting) {
                        SwingUtilities.invokeLater(() -> {
                            MainFrame.this.tfUserMsg.setText("...");
                            MainFrame.this.btnSend.doClick();
                        });
                    }
                } else if (response != null) {
                    SwingUtilities.invokeLater(() -> this.appendErrorMessage("Error sending message."));
                }
                SwingUtilities.invokeLater(() -> {
                    MainFrame.this.pnlChat.revalidate();
                    MainFrame.this.pnlChat.repaint();
                });
            }

            public void appendErrorMessage(String msg) {
                ErrorMessage pnl = new ErrorMessage();
                pnl.setMessage(msg, System.currentTimeMillis());
                MainFrame.this.pnlChat.add(pnl);
            }
        });
        this.btnSend.setEnabled(false);
        GroupLayout gl_panel = new GroupLayout(panel);
        gl_panel.setHorizontalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_panel.createSequentialGroup().addGap(1).addComponent(this.tfUserMsg, -1, 363, Short.MAX_VALUE).addGap(3).addComponent(this.btnSend).addGap(1)));
        gl_panel.setVerticalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfUserMsg, -1, 38, Short.MAX_VALUE).addComponent(this.btnSend, -1, -1, Short.MAX_VALUE)).addGap(1)));
        panel.setLayout(gl_panel);
        this.spChat = new JScrollPane();
        this.spChat.setVerticalScrollBarPolicy(22);
        this.spChat.setHorizontalScrollBarPolicy(31);
        this.contentPane.add((Component)this.spChat, "Center");
        this.pnlChat = new JPanel();
        this.pnlChat.setBackground(UIManager.getColor("window"));
        this.spChat.setViewportView(this.pnlChat);
        this.pnlChat.setLayout(new BoxLayout(this.pnlChat, 1));
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MainFrame frame = new MainFrame();
                    frame.setVisible(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private static enum UISTATE {
        LOGOUT,
        DISCONNECTED,
        CONNECTED,
        WAITING,
        IDLE;

    }
}

