/*
 * Decompiled with CFR 0.152.
 */
package chatclient;

import chatclient.Helper;
import chatclient.IMessagePanel;
import chatclient.MainFrame;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.GroupLayout;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

public class RemoteMessage
extends JPanel
implements IMessagePanel {
    private static final long serialVersionUID = 3317521967808457428L;
    private JEditorPane epUserMsg;
    private JLabel lblMsgTime;
    private JLabel lblUserIcon;

    @Override
    public void setMessage(String msg, long time) {
        Helper.setupEditorPane(this.epUserMsg);
        String css = "body { font-family: Arial, sans-serif; } a.btn_snd { text-decoration: none; background-color: #e1e1e1; font-weight:bold; word-wrap:none; }";
        String html = "<html><head><style type=\"text/css\">" + css + "</style></head><body>" + msg + "</body></html>";
        this.epUserMsg.setText(html);
        this.lblMsgTime.setText(Helper.getLocalTime(time));
    }

    @Override
    public void setIcon(String icon) {
        this.lblUserIcon.setIcon(Helper.loadIconFromResources(icon, 48, 48));
    }

    @Override
    public void onShown() {
    }

    public RemoteMessage() {
        final JPanel panel = new JPanel();
        panel.setBackground(new Color(245, 245, 245));
        this.lblUserIcon = new JLabel("");
        this.lblUserIcon.setIcon(Helper.loadIconFromResources("/chatbot.png", 48, 48));
        this.epUserMsg = new JEditorPane();
        this.epUserMsg.setContentType("text/html");
        this.epUserMsg.setEditable(false);
        this.lblMsgTime = new JLabel("00:00");
        this.lblMsgTime.setHorizontalAlignment(11);
        this.epUserMsg.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                int pos = RemoteMessage.this.epUserMsg.viewToModel2D(evt.getPoint());
                if (pos >= 0) {
                    try {
                        HTMLDocument doc = (HTMLDocument)RemoteMessage.this.epUserMsg.getDocument();
                        Element el = doc.getCharacterElement(pos);
                        AttributeSet ats = el.getAttributes();
                        SimpleAttributeSet obj = (SimpleAttributeSet)ats.getAttribute(HTML.Tag.A);
                        String id = obj.getAttribute(HTML.Attribute.ID).toString();
                        if (id != null && !id.isBlank()) {
                            Window wnd = Helper.getRootWindow(panel);
                            if (wnd != null && wnd instanceof MainFrame) {
                                ((MainFrame)wnd).onRemoteMsgLinkClicked(id);
                            } else {
                                System.out.println("Error opening link: " + id);
                                Toolkit.getDefaultToolkit().beep();
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        GroupLayout gl_panel = new GroupLayout(panel);
        gl_panel.setHorizontalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addGap(3).addComponent(this.lblUserIcon).addGap(3).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMsgTime, -1, 133, Short.MAX_VALUE).addComponent(this.epUserMsg, -2, 133, Short.MAX_VALUE)).addGap(3)));
        gl_panel.setVerticalGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addGap(3).addGroup(gl_panel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel.createSequentialGroup().addComponent(this.lblUserIcon, -2, 48, -2).addContainerGap()).addGroup(gl_panel.createSequentialGroup().addComponent(this.epUserMsg, -1, 63, Short.MAX_VALUE).addGap(3).addComponent(this.lblMsgTime).addGap(3)))));
        panel.setLayout(gl_panel);
        GroupLayout groupLayout = new GroupLayout(this);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5).addComponent(panel, -2, 185, Short.MAX_VALUE).addGap(50)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(5).addComponent(panel, -1, 76, Short.MAX_VALUE).addGap(5)));
        this.setLayout(groupLayout);
        Helper.enableRtlWhenNeeded(this);
    }
}

